/*
 * Created on 2015/09/04
 * Copyright (C) 2015 Koga Laboratory. All rights reserved.
 *
 */
package problem;

import org.mklab.daej.ivps.AbstractIvpsDifferentialAlgebraicEquation;

public class DoublePendulum extends AbstractIvpsDifferentialAlgebraicEquation {
  
  private double m1 = 1.0;
  private double m2 = 1.0;
  private double l1 = 1.0;
  private double l2 = 0.5;
  private double g = 9.8;

  public DoublePendulum() {
    this.fullnm = "DoublePendulum";     //　問題名
    this.problm = "doublepend";         //　問題の略称
    this.type = "DAE";                  //　問題の種類
    this.numberOfEquation = 10;         //　方程式の数

    this.numjac = false;        //　ヤコビ行列を定義するか(falseで定義する)
    this.mljac = this.numberOfEquation;     //　ヤコビ行列の下バンド幅
    this.mujac = this.numberOfEquation;     //　ヤコビ行列の上バンド幅
    this.mlmas = this.numberOfEquation;     //　M行列の下バンド幅
    this.mumas = this.numberOfEquation;     //　M行列の上バンド幅

    this.ind = new int[] {1, 1, 1, 1, 2, 2, 2, 2, 3, 3};    //　各変数の指数
    for (int i = 0; i < this.ind.length; i++)
      this.getInd()[i] = this.ind[i];
  }

  /* 初期値、初期微分値の設定 */
  @Override
  public void init(int neqn, double t, double[] y, double[] yprime, boolean[] consis) {
    // 初期値
    y[0] = 1.0;
    y[1] = 0.0;
    y[2] = 1.5;
    y[3] = 0.0;
    y[4] = 0.0;
    y[5] = 0.0;
    y[6] = 0.0;
    y[7] = 0.0;
    y[8] = 0.0;
    y[9] = 0.0;

    //　初期微分値
    yprime[0] = 0.0;
    yprime[1] = 0.0;
    yprime[2] = 0.0;
    yprime[3] = 0.0;
    yprime[4] = 0.0;
    yprime[5] = 9.8;
    yprime[6] = 0.0;
    yprime[7] = 9.8;
    yprime[8] = 0.0;
    yprime[9] = 0.0;

    consis[0] = true;
  }

  /* f(t,x)の記述 */
  @Override
  public void feval(int neqn, double t, double[] y, double[] yprime, double[] f, int[] ierr, double[] rpar, int[] ipar) {
    // f(t,x)
    f[0] = y[4];
    f[1] = y[5];
    f[2] = y[6];
    f[3] = y[7];
    f[4] = -y[8] * y[0] / this.l1 + y[9] * (y[2] - y[0]) / this.l2;
    f[5] = -y[8] * y[1] / this.l1 + y[9] * (y[3] - y[1]) / this.l2 + this.m1 * this.g;
    f[6] = -y[9] * (y[2] - y[0]) / this.l2;
    f[7] = -y[9] * (y[3] - y[1]) / this.l2 + this.m2 * this.g;
    f[8] = y[0] * y[0] + y[1] * y[1] - this.l1 * this.l1;
    f[9] = (y[2] - y[0]) * (y[2] - y[0]) + (y[3] - y[1]) * (y[3] - y[1]) - this.l2 * this.l2;
  }

  /* ヤコビ行列Jの設定 */
  @Override
  public void jeval(int ldim, int neqn, double t, double[] y, double[] yprime, double[][] dfdy, int[] ierr, double[] rpar, int[] ipar) {
    // ヤコビ行列J
    dfdy[0][4] = 1.0;
    dfdy[1][5] = 1.0;
    dfdy[2][6] = 1.0;
    dfdy[3][7] = 1.0;
    dfdy[4][0] = -y[8] / this.l1 - y[9] / this.l2;
    dfdy[4][2] = y[9] / this.l2;
    dfdy[4][8] = -y[0] / this.l1;
    dfdy[4][9] = (y[2] - y[0]) / this.l2;
    dfdy[5][1] = -y[8] / this.l1 - y[9] / this.l2;
    dfdy[5][3] = y[9] / this.l2;
    dfdy[5][8] = -y[1] / this.l1;
    dfdy[5][9] = (y[3] - y[1]) / this.l2;
    dfdy[6][0] = y[9] / this.l2;
    dfdy[6][2] = -y[9] / this.l2;
    dfdy[6][9] = -(y[2] - y[0]) / this.l2;
    dfdy[7][1] = y[9] / this.l2;
    dfdy[7][3] = -y[9] / this.l2;
    dfdy[7][9] = -(y[3] - y[1]) / this.l2;
    dfdy[8][0] = 2 * y[0];
    dfdy[8][1] = 2 * y[1];
    dfdy[9][0] = -2 * (y[2] - y[0]);
    dfdy[9][1] = -2 * (y[3] - y[1]);
    dfdy[9][2] = 2 * (y[2] - y[0]);
    dfdy[9][3] = 2 * (y[3] - y[1]);
  }

  /* M行列の設定 */
  @Override
  public void meval(int ldim, int neqn, double t, double[] y, double[] yprime, double[][] dfddy, int[] ierr, double[] rpar, int[] ipar) {
    // M行列
    dfddy[0][0] = 1.0;
    dfddy[1][1] = 1.0;
    dfddy[2][2] = 1.0;
    dfddy[3][3] = 1.0;
    dfddy[4][4] = this.m1;
    dfddy[5][5] = this.m1;
    dfddy[6][6] = this.m2;
    dfddy[7][7] = this.m2;
  }

  @Override
  public void setTolerances(int neqn, double[] rtol, double[] atol, boolean[] tolvec) {
    //dummy
  }

}
